/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.util;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.servlet.util.WCLLoggerServiceability;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ps.uil.ras.IUilServiceability;
import com.ibm.ps.wcl.core.WclFacade;
import com.ibm.ps.wcl.core.renderer.DefaultRendererFactory;
import com.ibm.ps.wcl.core.renderer.IRendererFactory;
import com.ibm.ps.wcl.core.renderer.RendererException;
import com.ibm.ps.wcl.core.resource.IResourceLoaderManager;
import com.ibm.ps.wcl.core.resource.ResourceLoaderManager;
import com.ibm.ps.wcl.core.skin.DefaultSkinManager;
import com.ibm.ps.wcl.core.skin.ISkinManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class WCLUtil {
    private static final String TRACE_MASKT = "XWCLUTLT";
    private static final String TRACE_MASKF = "XWCLUTLF";
    private static WCLUtil wclUtil;
    private IRendererFactory rendererFactory;
    private ISkinManager skinManager;
    private IResourceLoaderManager resourceLoaderManager;
    private IUilServiceability serviceabilityInterface;

    private WCLUtil() {
    }

    private synchronized void createWclObjects() throws HException {
        if (this.rendererFactory != null) {
            return;
        }
        String[] customRendererDefinitions = this.getCustomRendererDefinitions();
        Trace.trace(TRACE_MASKF, "Creating heavyweight WCL objects");
        long beforeTime = System.currentTimeMillis();
        try {
            this.rendererFactory = new DefaultRendererFactory(customRendererDefinitions);
        }
        catch (RendererException e) {
            Trace.trace(TRACE_MASKT, "Error creating global DefaultRendererFactory.");
            if (e instanceof RendererException.EMultipleErrors) {
                Trace.trace(TRACE_MASKT, "Multiple errors recognized:");
                RendererException.EMultipleErrors me = (RendererException.EMultipleErrors)e;
                int count = me.getMessageCount();
                for (int i = 0; i < count; ++i) {
                    Trace.trace(TRACE_MASKT, me.getMessage(i));
                }
            }
            Trace.trace(TRACE_MASKT, (Object)e);
            if (e.getException() != null) {
                Trace.trace(TRACE_MASKT, "The RendererException wrapped this exception");
                Trace.trace(TRACE_MASKT, e.getException());
            }
            throw new HException(e);
        }
        this.skinManager = new DefaultSkinManager();
        this.resourceLoaderManager = new ResourceLoaderManager("/wclres");
        if (ServletRuntime.getRuntime().getServletOptions().getBoolean("wcl.servicability", false)) {
            this.serviceabilityInterface = new WCLLoggerServiceability(true);
        }
        long elapsed = System.currentTimeMillis() - beforeTime;
        Trace.trace(TRACE_MASKT, "Elapsed time to create heavyweight WCL objects: " + elapsed + "ms");
    }

    public static synchronized WCLUtil getWCLUtil() {
        if (wclUtil == null) {
            wclUtil = new WCLUtil();
        }
        return wclUtil;
    }

    public WclFacade createFacade(String path) throws HException {
        this.createWclObjects();
        return new WclFacade(path, this.rendererFactory, this.skinManager, this.resourceLoaderManager, null, this.serviceabilityInterface);
    }

    public void initializeInBackground() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    WCLUtil.this.createWclObjects();
                }
                catch (HException hException) {
                    // empty catch block
                }
            }
        }, "WCL Heavyweight Object Initialization");
        thread.setDaemon(true);
        thread.start();
    }

    private String[] getCustomRendererDefinitions() throws HException {
        InputStream defns = this.getClass().getResourceAsStream("wclCustomRenderer.definitions");
        if (defns == null) {
            return null;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(defns));
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            try {
                in.close();
            }
            catch (IOException ee) {
                // empty catch block
            }
            throw new HException("Error reading wclCustomRenderer.definitions: " + e.getMessage());
        }
        String[] result = new String[lines.size()];
        lines.toArray(result);
        return result;
    }
}

